# read data1.txt file
stu1 <- read.table("data1.txt",header = T,sep=",")

# select nadin's grades with matrix notation
stu1[1,]

# list all students if the midterm grade is higher than 60.
stu1[stu1$Midterm>60,]

# read data2.txt file
stu2 <- read.table("data2.txt",header = T,sep="")

# merge two data frames
stu <- merge(stu1,stu2)

# add a new column "Total", and compute the final grade:
# 30% Lab, 25% Midterm, 45% Final

stu$Total <- stu$Lab*0.3 + stu$Midterm*0.25 + stu$Final*0.45

# add a new boolean column "Passed",
# if the total grade is greater than 60, then the student passes the course
# otherwise she fails!

stu$Passed <- ifelse(stu$Total>60,T,F)

# list all students who failed the course
stu[stu$Passed==F,]

# show the relation between final and total grades on a plot
plot(stu$Final,stu$Total,xlab="Final",ylab="Total",pch=2)

